# Hostel Management System

A Python-based Hostel Management System using Flask, MySQL, HTML/CSS/JS, and Bootstrap 5. Now WSGI-compatible for deployment on platforms like Railway.

## Features

- **Student Management**: Add, update, delete, and view student records.
- **Room Management**: Track room availability, allocate and vacate rooms.
- **Fee Management**: Record fees, track payments, generate receipts.
- **Visitor Management**: Log visitor details with time-in/out.
- **Complaint Box**: Students can submit complaints, admin can review and resolve.
- **Authentication**: Role-based access for admin and students.
- **Reports**: Generate HTML reports for students, rooms, payments, and visitors.

## Requirements

- Python 3.x
- MySQL (via XAMPP or cloud database)
- Flask
- mysql-connector-python library

## Setup Instructions

1. **Install Python**: Download and install Python from https://www.python.org/downloads/. Make sure to add Python to your PATH.

2. **Install Dependencies**:

   ```
   pip install -r requirements.txt
   ```

3. **Setup MySQL Database**:

   - Start XAMPP Control Panel and start the MySQL service.
   - Open phpMyAdmin (http://localhost/phpmyadmin) and create a database named `hostel_management`.
   - Import the migration script: Go to Import tab in phpMyAdmin, select `migrations/create_tables.sql`, and import.
   - Import the seeder script: Select `seeders/seed_admin.sql` and import.

   **Alternative Command Line (if phpMyAdmin doesn't work):**

   - Open Command Prompt as Administrator
   - Navigate to project folder: `cd C:\Users\Dell\Documents\hotel-management`
   - Create database: `C:\xampp\mysql\bin\mysql.exe -u root -p"" -P 3307 -e "CREATE DATABASE IF NOT EXISTS hostel_management;"`
   - Import migration: `C:\xampp\mysql\bin\mysql.exe -u root -p"" -P 3307 hostel_management -e "source migrations/create_tables.sql"`
   - Import seeder: `C:\xampp\mysql\bin\mysql.exe -u root -p"" -P 3307 hostel_management -e "source seeders/seed_admin.sql"`

4. **Configure Database Connection**:

   - In `db.py`, update the `DB_CONFIG` if your MySQL credentials differ from default (root, no password).
   - For Railway deployment, set environment variables for database connection.

5. **Run the Application**:

   ```
   python app.py
   ```

   - The server will start on http://localhost:8000

6. **Login Credentials**:
   - Admin: username `admin`, password `admin123`
   - Students: Created via admin panel, default password `student123`

## Deployment on Railway

This app is now WSGI-compatible and can be deployed on Railway:

1. Create a Railway account and project.
2. Connect your GitHub repository.
3. Set environment variables in Railway:
   - `SECRET_KEY`: A random secret key for Flask sessions.
   - `PORT`: Usually set automatically by Railway.
   - Database variables if using Railway's database service.
4. Railway will automatically detect the Flask app and deploy it.

## Project Structure

```
hostel-management/
├── migrations/
│   └── create_tables.sql
├── seeders/
│   └── seed_admin.sql
│   └── seed_students.sql
├── templates/
│   ├── login.html
│   ├── admin_dashboard.html
│   ├── student_dashboard.html
│   ├── manage_students.html
│   ├── manage_rooms.html
│   ├── manage_fees.html
│   ├── manage_visitors.html
│   ├── manage_complaints.html
│   ├── reports.html
│   ├── student_complaints.html
│   ├── student_visitors.html
│   ├── update_student.html
│   ├── delete_student.html
│   ├── update_fee.html
│   ├── update_visitor.html
│   └── update_complaint.html
├── static/  # (for future CSS/JS files)
├── app.py   # Main Flask application
├── db.py    # Database functions
├── auth.py  # Authentication logic
├── requirements.txt  # Python dependencies
├── start.sh  # Startup script
├── TODO.md  # Development notes
└── README.md
```

## Usage

- Access the application at http://localhost:8000 (local) or your Railway URL (deployed)
- Login as admin to manage all aspects of the hostel.
- Students can login to view their details, submit complaints, and log visitors.

## Notes

- This implementation uses Flask for WSGI compatibility.
- Sessions are handled by Flask (persistent across requests but not restarts).
- Passwords are hashed using SHA256.
- Bootstrap 5 is loaded via CDN for styling.
- Now deployable on Railway and other WSGI-compatible platforms.
