import mysql.connector
import hashlib
DB_CONFIG = {
    'host': 'localhost',
    'user': 'root', 
    'password': '',
    'database': 'hostel_management',
    'port': 3306
}

def get_db_connection():
    return mysql.connector.connect(**DB_CONFIG)

def hash_password(password):
    return hashlib.sha256(password.encode()).hexdigest()

# User functions
def create_user(username, password, role):
    conn = get_db_connection()
    cursor = conn.cursor()
    hashed_pw = hash_password(password)
    cursor.execute("INSERT INTO users (username, password, role) VALUES (%s, %s, %s)", (username, hashed_pw, role))
    conn.commit()
    user_id = cursor.lastrowid
    cursor.close()
    conn.close()
    return user_id

def authenticate_user(username, password):
    conn = get_db_connection()
    cursor = conn.cursor(dictionary=True)
    hashed_pw = hash_password(password)
    cursor.execute("SELECT * FROM users WHERE username = %s AND password = %s", (username, hashed_pw))
    user = cursor.fetchone()
    cursor.close()
    conn.close()
    return user

def get_user_by_id(user_id):
    conn = get_db_connection()
    cursor = conn.cursor(dictionary=True)
    cursor.execute("SELECT * FROM users WHERE id = %s", (user_id,))
    user = cursor.fetchone()
    cursor.close()
    conn.close()
    return user

# Student functions
def create_student(user_id, name, email, phone, address, admission_date):
    conn = get_db_connection()
    cursor = conn.cursor()
    cursor.execute("INSERT INTO students (user_id, name, email, phone, address, admission_date) VALUES (%s, %s, %s, %s, %s, %s)",
                   (user_id, name, email, phone, address, admission_date))
    conn.commit()
    student_id = cursor.lastrowid
    cursor.close()
    conn.close()
    return student_id

def get_all_students():
    conn = get_db_connection()
    cursor = conn.cursor(dictionary=True)
    cursor.execute("SELECT * FROM students")
    students = cursor.fetchall()
    cursor.close()
    conn.close()
    return students

def get_student_by_id(student_id):
    conn = get_db_connection()
    cursor = conn.cursor(dictionary=True)
    cursor.execute("SELECT * FROM students WHERE id = %s", (student_id,))
    student = cursor.fetchone()
    cursor.close()
    conn.close()
    return student

def update_student(student_id, name, email, phone, address, room_id, status):
    conn = get_db_connection()
    cursor = conn.cursor()
    cursor.execute("UPDATE students SET name=%s, email=%s, phone=%s, address=%s, room_id=%s, status=%s WHERE id=%s",
                   (name, email, phone, address, room_id, status, student_id))
    conn.commit()
    cursor.close()
    conn.close()

def delete_student(student_id):
    conn = get_db_connection()
    cursor = conn.cursor()
    cursor.execute("DELETE FROM students WHERE id = %s", (student_id,))
    conn.commit()
    cursor.close()
    conn.close()

# Room functions
def create_room(room_number, capacity, room_type):
    conn = get_db_connection()
    cursor = conn.cursor()
    cursor.execute("INSERT INTO rooms (room_number, capacity, type) VALUES (%s, %s, %s)", (room_number, capacity, room_type))
    conn.commit()
    room_id = cursor.lastrowid
    cursor.close()
    conn.close()
    return room_id

def get_all_rooms():
    conn = get_db_connection()
    cursor = conn.cursor(dictionary=True)
    cursor.execute("SELECT * FROM rooms")
    rooms = cursor.fetchall()
    cursor.close()
    conn.close()
    return rooms

def get_room_by_id(room_id):
    conn = get_db_connection()
    cursor = conn.cursor(dictionary=True)
    cursor.execute("SELECT * FROM rooms WHERE id = %s", (room_id,))
    room = cursor.fetchone()
    cursor.close()
    conn.close()
    return room

def allocate_room(room_id, student_id):
    conn = get_db_connection()
    cursor = conn.cursor()
    cursor.execute("UPDATE rooms SET status='occupied', allocated_to=%s WHERE id=%s", (student_id, room_id))
    cursor.execute("UPDATE students SET room_id=%s WHERE id=%s", (room_id, student_id))
    conn.commit()
    cursor.close()
    conn.close()

def vacate_room(room_id):
    conn = get_db_connection()
    cursor = conn.cursor()
    cursor.execute("UPDATE rooms SET status='available', allocated_to=NULL WHERE id=%s", (room_id,))
    cursor.execute("UPDATE students SET room_id=NULL WHERE room_id=%s", (room_id,))
    conn.commit()
    cursor.close()
    conn.close()

# Fee functions
def create_fee(student_id, amount, fee_type, due_date):
    conn = get_db_connection()
    cursor = conn.cursor()
    cursor.execute("INSERT INTO fees (student_id, amount, type, due_date) VALUES (%s, %s, %s, %s)",
                   (student_id, amount, fee_type, due_date))
    conn.commit()
    fee_id = cursor.lastrowid
    cursor.close()
    conn.close()
    return fee_id

def get_fees_by_student(student_id):
    conn = get_db_connection()
    cursor = conn.cursor(dictionary=True)
    cursor.execute("SELECT * FROM fees WHERE student_id = %s", (student_id,))
    fees = cursor.fetchall()
    cursor.close()
    conn.close()
    return fees

def get_all_fees():
    conn = get_db_connection()
    cursor = conn.cursor(dictionary=True)
    cursor.execute("SELECT * FROM fees")
    fees = cursor.fetchall()
    cursor.close()
    conn.close()
    return fees

def get_fee_by_id(fee_id):
    conn = get_db_connection()
    cursor = conn.cursor(dictionary=True)
    cursor.execute("SELECT * FROM fees WHERE id = %s", (fee_id,))
    fee = cursor.fetchone()
    cursor.close()
    conn.close()
    return fee

def update_fee_status(fee_id, status, payment_date=None):
    conn = get_db_connection()
    cursor = conn.cursor()
    cursor.execute("UPDATE fees SET status=%s, payment_date=%s WHERE id=%s", (status, payment_date, fee_id))
    conn.commit()
    cursor.close()
    conn.close()

# Visitor functions
def create_visitor(student_id, name, address, relation, time_in):
    conn = get_db_connection()
    cursor = conn.cursor()
    cursor.execute("INSERT INTO visitors (student_id, name, address, relation, time_in) VALUES (%s, %s, %s, %s, %s)",
                   (student_id, name, address, relation, time_in))
    conn.commit()
    visitor_id = cursor.lastrowid
    cursor.close()
    conn.close()
    return visitor_id

def get_visitors_by_student(student_id):
    conn = get_db_connection()
    cursor = conn.cursor(dictionary=True)
    cursor.execute("SELECT * FROM visitors WHERE student_id = %s", (student_id,))
    visitors = cursor.fetchall()
    cursor.close()
    conn.close()
    return visitors

def get_all_visitors():
    conn = get_db_connection()
    cursor = conn.cursor(dictionary=True)
    cursor.execute("SELECT * FROM visitors")
    visitors = cursor.fetchall()
    cursor.close()
    conn.close()
    return visitors

def update_visitor_time_out(visitor_id, time_out):
    conn = get_db_connection()
    cursor = conn.cursor()
    cursor.execute("UPDATE visitors SET time_out=%s WHERE id=%s", (time_out, visitor_id))
    conn.commit()
    cursor.close()
    conn.close()

def get_visitor_by_id(visitor_id):
    conn = get_db_connection()
    cursor = conn.cursor(dictionary=True)
    cursor.execute("SELECT * FROM visitors WHERE id = %s", (visitor_id,))
    visitor = cursor.fetchone()
    cursor.close()
    conn.close()
    return visitor

# Complaint functions
def create_complaint(student_id, subject, description):
    conn = get_db_connection()
    cursor = conn.cursor()
    cursor.execute("INSERT INTO complaints (student_id, subject, description) VALUES (%s, %s, %s)",
                   (student_id, subject, description))
    conn.commit()
    complaint_id = cursor.lastrowid
    cursor.close()
    conn.close()
    return complaint_id

def get_all_complaints():
    conn = get_db_connection()
    cursor = conn.cursor(dictionary=True)
    cursor.execute("SELECT * FROM complaints")
    complaints = cursor.fetchall()
    cursor.close()
    conn.close()
    return complaints

def update_complaint_status(complaint_id, status, resolved_at=None):
    conn = get_db_connection()
    cursor = conn.cursor()
    cursor.execute("UPDATE complaints SET status=%s, resolved_at=%s WHERE id=%s", (status, resolved_at, complaint_id))
    conn.commit()
    cursor.close()
    conn.close()

def get_complaint_by_id(complaint_id):
    conn = get_db_connection()
    cursor = conn.cursor(dictionary=True)
    cursor.execute("SELECT * FROM complaints WHERE id = %s", (complaint_id,))
    complaint = cursor.fetchone()
    cursor.close()
    conn.close()
    return complaint
